use creditoscomercio;

alter table remotecredito add column valInteresAFacturar decimal(10,2) null;
alter table credito add column valInteresAFacturar decimal(10,2) null;

update credito set valInteresAFacturar = valinteres where valInteresAFacturar is null;
update remotecredito set valInteresAFacturar = valInteres where valInteresAFacturar is null;

alter table tipocliente add column valCupoInicialRenovacionAdelantada decimal(10,2) null;
alter table tipocliente add column valCupoInicialAperturaAdelantada decimal(10,2) null;
alter table tipocliente add column valCupoInicialRenovacionVencida decimal(10,2) null;
alter table tipocliente add column valCupoInicialAperturaVencida decimal(10,2) null;

update tipocliente set valCupoInicialRenovacionAdelantada = valCupoInicial where valCupoInicialRenovacionAdelantada is null;
update tipocliente set valCupoInicialRenovacionVencida = valCupoInicial where valCupoInicialRenovacionVencida is null;
update tipocliente set valCupoInicialAperturaAdelantada = valCupoInicial where valCupoInicialAperturaAdelantada is null;
update tipocliente set valCupoInicialAperturaVencida = valCupoInicial where valCupoInicialAperturaVencida is null;
 
/*alter table tipocliente drop column valCupoInicial;*/

alter table parametro modify strvalor varchar(500) not null;


alter table firmadigital modify `binFirmaImagen` varbinary(10000) NULL;
alter table firmadigital modify `binFirma` varbinary(50000) NULL;


CREATE TABLE IF NOT EXISTS `firmadigital` (
  `codFirmaDigital` int(11) NOT NULL AUTO_INCREMENT,
  `codCentral` int(11) DEFAULT NULL,
  `codCliente` int(11) NOT NULL,
  `codComercio` int(11) NOT NULL,
  `fchCreacion` datetime NOT NULL,
  `binFirma` varbinary(50000) DEFAULT NULL,
  `binFirmaImagen` varbinary(10000) DEFAULT NULL,
  `flgActivo` boolean DEFAULT 1 NOT NULL,
  PRIMARY KEY (`codFirmaDigital`),
  KEY `FK_FIRMADIGITAL_CLIENTEXCOMERCIO_idx` (`codCliente`,`codComercio`),
  KEY `IX_FIRMADIGITAL_CODCENTRAL` (`codCentral`),
  CONSTRAINT `FK_FIRMADIGITAL_CLIENTEXCOMERCIO` FOREIGN KEY (`codCliente`, `codComercio`) REFERENCES `clientexcomercio` (`codCliente`, `codComercio`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `remotefirmadigital` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codFirmaDigital` int(11) DEFAULT NULL,
  `codCliente` int(11) DEFAULT NULL,
  `codClienteComercio` int(11) DEFAULT NULL,
  `codComercio` int(11) DEFAULT NULL,
  `fchCreacion` datetime DEFAULT NULL,
  `binFirma` varbinary(50000) DEFAULT NULL,
  `binFirmaImagen` varbinary(10000) DEFAULT NULL,
  `flgActivo` boolean DEFAULT 1 NOT NULL,
  `codFirmaDigitalComercio` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;



alter table remotefirmadigital modify `binFirmaImagen` varbinary(10000) NULL;
alter table remotefirmadigital modify `binFirma` varbinary(50000) NULL;

alter table clientexcomercio add valSaldoCapital numeric(10,2) not null default 0;
alter table clientexcomercio add valCapitalCuotasPagadas numeric(10,2) not null default 0;
alter table clientexcomercio add valSaldoCapitalRefinanciaciones numeric(10,2) not null default 0;

update ClientexComercio set valsaldoCapital = ifnull((
select sum(valCapital - valCapitalPagado - valCapitalAjustado) from 
Credito c where codEstado = 1 
and codEstadoDeProceso <> 4 and codEstadoDeProceso <> 7 
and flgRefinanciado = 0 
and c.codCliente = clientexcomercio.codCliente and c.codComercio = ClientexComercio.codComercio), 0);

update ClientexComercio set valsaldoCapitalrefinanciaciones = ifnull((
select sum(valCapital - valCapitalPagado - valCapitalAjustado) from 
Credito c where codEstado = 1 
and codEstadoDeProceso <> 4 and codEstadoDeProceso <> 7 
and flgRefinanciado = 1 
and c.codCliente = clientexcomercio.codCliente and c.codComercio = ClientexComercio.codComercio), 0);

update ClientexComercio set valCapitalCuotasPagadas = ifnull((
select sum(ri.valImporte - ri.valInteres - ri.valAjuste)  - 
sum(case when c.flgCuotaAdelantada = 1 and nroCuota = 1 then round(c.valCapital / c.cntCuotas, 0) else 0 end) 
from Credito c 
inner join ReciboItem ri on c.codCredito = ri.codCredito 
inner join Recibo r on ri.codRecibo = r.codRecibo 
where codEstado <> 4 
and codEstadoDeProceso <> 4 and codEstadoDeProceso <> 7 
and flgRefinanciado = 0 
and r.flgBaja = 0 
and r.flgAjuste = 0 
and c.codCliente = clientexcomercio.codCliente and c.codComercio = ClientexComercio.codComercio), 0);

alter table tipocliente add valPorcAdicCupoDeCapitalPago numeric(10,6) not null default 0;

alter table cliente add codTipoCliente smallint null;
alter table remotecliente add codTipoCliente smallint null;


CREATE TABLE IF NOT EXISTS `foto` (
  `codFoto` int(11) NOT NULL AUTO_INCREMENT,
  `codCentral` int(11) DEFAULT NULL,
  `codCliente` int(11) NOT NULL,
  `codCredito` int(11) NULL,
  `codComercio` int(11) NOT NULL,
  `fchCreacion` datetime NOT NULL,
  `binFoto` varbinary(30000) DEFAULT NULL,
  `flgActivo` boolean DEFAULT 1 NOT NULL,
  PRIMARY KEY (`codFoto`),
  KEY `FK_FOTO_CLIENTEXCOMERCIO_idx` (`codCliente`,`codComercio`),
  KEY `FK_FOTO_CREDITO_idx` (`codCredito`),
  KEY `IX_FOTO_CODCENTRAL` (`codCentral`),
  CONSTRAINT `FK_FOTO_CLIENTEXCOMERCIO` FOREIGN KEY (`codCliente`, `codComercio`) REFERENCES `clientexcomercio` (`codCliente`, `codComercio`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_FOTO_CREDITO` FOREIGN KEY (`codCredito`) REFERENCES `credito` (`codCredito`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `remotefoto` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codFoto` int(11) DEFAULT NULL,
  `codCliente` int(11) DEFAULT NULL,
  `codClienteComercio` int(11) DEFAULT NULL,
  `codCredito` int(11) DEFAULT NULL,
  `codCreditoComercio` int(11) DEFAULT NULL,
  `codComercio` int(11) DEFAULT NULL,
  `fchCreacion` datetime DEFAULT NULL,
  `binFoto` varbinary(30000) DEFAULT NULL,
  `flgActivo` boolean DEFAULT 1 NOT NULL,
  `codFotoComercio` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;


alter table tipocliente add column flgActivo bit not null default 1;
alter table tipocliente add column codCategoria tinyint null;
alter table tipocliente add column strAbreviatura varchar(3) null;
alter table tipocliente add column strNivelReportes varchar(100) null;
alter table tipocliente add column valCupoInicial decimal(10,2) null;
alter table tipocliente add column codTipoClienteSinPapeles smallint null;

alter table cliente add column codTipoCliente smallint null;

alter table tipocliente add column strPapelesApertura varchar(500) null;


CREATE TABLE `plan2` (
  `codPlan` int(11) NOT NULL,
  `strNombre` varchar(50) NOT NULL,
  `flgActivo` bit(1) NOT NULL,
  PRIMARY KEY (`codPlan`),
  UNIQUE KEY `codPlan_UNIQUE` (`codPlan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


CREATE TABLE `plancuota` (
  `codPlanCuota` int(11) NOT NULL,
  `codPlan` int(11) NOT NULL,
  `nroCuota` tinyint(4) NOT NULL,
  `valCoeficiente` decimal(10,6) NOT NULL,
  `valPorcentajeComision` decimal(10,6) DEFAULT NULL,
  `flgActivo` bit(1) NOT NULL,
  `cntDiasPlazo` tinyint(4) NOT NULL,
  PRIMARY KEY (`codPlanCuota`),
  UNIQUE KEY `codPlanCuota_UNIQUE` (`codPlanCuota`),
  KEY `FK_PLANCUOTA_PLAN_idx` (`codPlan`),
  CONSTRAINT `FK_PLANCUOTA_PLAN` FOREIGN KEY (`codPlan`) REFERENCES `plan2` (`codPlan`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



alter table tipocliente add column codPlanAdelantada int null;
alter table tipocliente add column codPlanVencida int null;
alter table tipocliente add column codPlanBonificada int null;

alter table tipocliente add column strCuotasAdelantada varchar(100) null;
alter table tipocliente add column strCuotasVencida varchar(100) null;

alter table tipocliente add KEY `FK_TIPOCLIENTE_PLAN_ADELANTADA_idx` (`codPlanAdelantada`);
alter table tipocliente add CONSTRAINT `FK_TIPOCLIENTE_PLAN_ADELANTADA` FOREIGN KEY (`codPlanAdelantada`) REFERENCES `plan2` (`codPlan`) ON DELETE NO ACTION ON UPDATE NO ACTION;
alter table tipocliente add KEY `FK_TIPOCLIENTE_PLAN_VENCIDA_idx` (`codPlanVencida`);
alter table tipocliente add CONSTRAINT `FK_TIPOCLIENTE_PLAN_VENCIDA` FOREIGN KEY (`codPlanVencida`) REFERENCES `plan2` (`codPlan`) ON DELETE NO ACTION ON UPDATE NO ACTION;
alter table tipocliente add KEY `FK_TIPOCLIENTE_PLAN_BONIFICADA_idx` (`codPlanBonificada`);
alter table tipocliente add CONSTRAINT `FK_TIPOCLIENTE_PLAN_BONIFICADA` FOREIGN KEY (`codPlanBonificada`) REFERENCES `plan2` (`codPlan`) ON DELETE NO ACTION ON UPDATE NO ACTION;

update tipocliente set strCuotasAdelantada = '-1' where cntCuotasAdelantada = -1 and strCuotasAdelantada is null;
update tipocliente set strCuotasVencida = '-1' where cntCuotasVencida = -1 and strCuotasVencida is null;
update tipocliente set strCuotasAdelantada = '' where cntCuotasAdelantada = 0 and strCuotasAdelantada is null;
update tipocliente set strCuotasVencida = '' where cntCuotasVencida = 0 and strCuotasVencida is null;

update tipocliente set strCuotasAdelantada = (SELECT group_concat(year) 
FROM   (   SELECT @i:= @i + 1 AS YEAR
           FROM   INFORMATION_SCHEMA.COLLATION_CHARACTER_SET_APPLICABILITY,
                  ( SELECT @i:= 0) AS i
        ) As Y
WHERE   Year BETWEEN 1 AND tipocliente.cntCuotasAdelantada
ORDER BY Year)
where cntCuotasAdelantada > 0
and strCuotasAdelantada is null;

update tipocliente set strCuotasVencida = (SELECT group_concat(year) 
FROM   (   SELECT @i:= @i + 1 AS YEAR
           FROM   INFORMATION_SCHEMA.COLLATION_CHARACTER_SET_APPLICABILITY,
                  ( SELECT @i:= 0) AS i
        ) As Y
WHERE   Year BETWEEN 1 AND tipocliente.cntCuotasVencida
ORDER BY Year)
where cntCuotasVencida > 0
and strCuotasVencida is null;

alter table tipocliente modify column strNivelReportes varchar(100) null;
alter table recibo add constraint unique (codcentral);
alter table direccion add constraint unique (codcentral);
alter table liquidacion add constraint unique (codcentral);
alter table telefono add constraint unique (codcentral);
alter table recibo add constraint unique (codcentral);
alter table pago add constraint unique (codcentral);
alter table notacredito add constraint unique (codcentral);
alter table mensaje add constraint unique (codcentral);

alter table direccion modify strdepartamento varchar(5) default null;
alter table remotedireccion modify strdepartamento varchar(5) default null;
alter table acuerdo add column flgPagoUnico bit(1) NOT NULL default 0;
alter table refinanciacion add column flgActivo bit not null default 1;
alter table refinanciacion modify column `codCreditoRefinanciado` int NULL;
alter table remoterefinanciacion add column flgActivo bit not null default 1;
alter table remoterefinanciacion modify column `codCreditoRefinanciadoComercio` int NULL;


CREATE TABLE `terminal` (
  `codTerminal` int(11) NOT NULL,
  `codComercio` int(11) NOT NULL,
  `strClave` varchar(50) NOT NULL,
  `strNombre` varchar(100) NOT NULL,
  `flgActivo` bit(1) NOT NULL,
  PRIMARY KEY (`codTerminal`),
  UNIQUE KEY `codTerminal_UNIQUE` (`codTerminal`),
  KEY `FK_TERMINAL_COMERCIO_idx` (`codComercio`),
  CONSTRAINT `FK_TERMINAL_COMERCIO` FOREIGN KEY (`codComercio`) REFERENCES `comercio` (`codComercio`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

alter table credito add column codTerminal int null;

alter table credito add `strCbu` varchar(50) NULL;

alter table remotecredito add `strCbu` varchar(50) NULL;

DROP PROCEDURE recalcular_clientexcomercio;
DELIMITER //
CREATE PROCEDURE recalcular_clientexcomercio(pcliente int, pcomercio int)
BEGIN
	declare vvalCapitalAdelantada decimal(10,2);
	declare vvalCapitalVencida decimal(10,2);
	declare vvalCapitalPagado decimal(10,2);
	declare vvalCapitalRefinanciado decimal(10,2);
	declare vvalCapitalRefinanciadoPagado decimal(10,2);
	declare vvalCuotasPagadas decimal(10,2);
	declare vvalSaldoCapital decimal(10,2);
	declare vvalSaldoCapitalRefinanciaciones decimal(10,2);
	declare vvalCapitalCuotasPagadas decimal(10,2);
    declare vvalCapitalCuotasPagadasAdelantadas decimal(10,2);
	declare vcapital decimal(10,2);
	#por cada clientexcomercio
    
    #tomamos los creditos refinanciados y activos 
	select ifnull(sum(valcapital - valcapitalajustado - valcapitalpagado), 0) 
		into vvalSaldoCapitalRefinanciaciones
        from credito 
        where codcliente = pcliente and codcomercio = pcomercio 
			#and codestado != 4 
            and codEstadoDeProceso != 4 
            and codEstadoDeProceso != 7
            and codestado = 1
            and flgRefinanciado = 1;
	
	#tomamos los creditos refinanciados
	select ifnull(sum(valcapital - valcapitalajustado), 0), ifnull(sum(valcapitalpagado), 0)
		into vvalCapitalRefinanciado, vvalCapitalRefinanciadoPagado
        from credito 
        where codcliente = pcliente and codcomercio = pcomercio 
			and codestado != 4 
            and codEstadoDeProceso != 4 
            and codEstadoDeProceso != 7
            and flgRefinanciado = 1;
            
	#tomamos los creditos no refis activos 
	select ifnull(sum(valcapital - valcapitalajustado - valcapitalpagado), 0) 
		into vvalSaldoCapital
        from credito 
        where codcliente = pcliente and codcomercio = pcomercio 
			#and codestado != 4 
            and codEstadoDeProceso != 4 
            and codEstadoDeProceso != 7
            and codestado = 1
            and flgRefinanciado = 0;  
            
	#tomamos los creditos no refis
	select ifnull(sum(valcapitalpagado), 0)
		into vvalCapitalCuotasPagadas
        from credito 
        where codcliente = pcliente and codcomercio = pcomercio 
			and codestado != 4 
            and codEstadoDeProceso != 4 
            and codEstadoDeProceso != 7
            and flgRefinanciado = 0;  
	
    #tomamos los creditos no refis y cuota adelantada
	select ifnull(sum(valcapital), 0), ifnull(sum(round(valCapital / cntcuotas, 0)), 0)
		into vvalCapitalAdelantada, vvalCapitalCuotasPagadasAdelantadas
        from credito 
        where codcliente = pcliente and codcomercio = pcomercio 
			and codestado != 4 
            and codEstadoDeProceso != 4 
            and codEstadoDeProceso != 7
            and flgRefinanciado = 0
            and flgCuotaAdelantada = 1;  
	#tomamos los creditos no refis y cuota vencida
	select ifnull(sum(valcapital), 0)
		into vvalCapitalVencida
        from credito 
        where codcliente = pcliente and codcomercio = pcomercio 
			and codestado != 4 
            and codEstadoDeProceso != 4 
            and codEstadoDeProceso != 7
            and flgRefinanciado = 0
            and flgCuotaAdelantada = 0; 
		
    
    #tomamos los creditos no refis
	select ifnull(sum(valcapitalPagado), 0), ifnull(sum(valCapitalPagado + valinteresPagado), 0)
		into vvalCapitalPagado, vvalCuotasPagadas
        from credito 
        where codcliente = pcliente and codcomercio = pcomercio 
			and codestado != 4 
            and codEstadoDeProceso != 4 
            and codEstadoDeProceso != 7
            and flgRefinanciado = 0; 
		
	update clientexcomercio set 
		valCapitalAdelantada = ifnull(vvalCapitalAdelantada, 0),
		valCapitalVencida = ifnull(vvalCapitalVencida, 0),
		valCapitalPagado = ifnull(vvalCapitalPagado, 0),
		valCapitalRefinanciado = ifnull(vvalCapitalRefinanciado , 0),
		valCapitalRefinanciadoPagado = ifnull(vvalCapitalRefinanciadoPagado, 0) ,
		valCuotasPagadas = ifnull(vvalCuotasPagadas, 0),
		valSaldoCapital = ifnull(vvalSaldoCapital, 0),
		valSaldoCapitalRefinanciaciones = ifnull(vvalSaldoCapitalRefinanciaciones, 0),
		valCapitalCuotasPagadas = ifnull(vvalCapitalCuotasPagadas - vvalCapitalCuotasPagadasAdelantadas, 0)
    where  codcliente = pcliente and codcomercio = pcomercio;
        
END; //

alter table acuerdo add column valPorcentajeComisionEstudio smallint not null default 0;
