function updateWar($destinyFolderBase)
{
	# Ruta al archivo WAR
	$warPath = [System.IO.Path]::Combine($destinyFolderBase, "jetty\jetty\webapps\CreditosComercio.war")

	$updaterFile = [System.IO.Path]::Combine($global:ScriptRoot, "actualizacionCreditosComercio.rar") 
    #Get-Item .\ | Select-Object -ExpandProperty FullName
	
	if (-not (Test-Path -Path $warPath)) {
		Write-Host "ERROR: No se encontro el archivo WAR buscado en la ubicacion $warPath" -ForegroundColor Red
		return $false
	}
	
	if (-not (Test-Path -Path $updaterFile)) {
		Write-Host "ERROR: No se encontro el archivo de actualizacion buscado en la ubicacion $updaterFile" -ForegroundColor Red
		return $false
	}

    $WinRar = findPathInProgramFiles("WinRAR")
    $WinRar = $WinRar + "\winrar.exe"
    if (-not (Test-Path -Path $WinRar)) {
		Write-Host "ERROR: No se encontro WinRAR instalado" -ForegroundColor Red
		return $false
	}

		
	$scriptFile = [System.IO.Path]::Combine($global:ScriptRoot, "actualizarWar.bat") 
	
	if (-not (Test-Path -Path $scriptFile)) {
		Write-Host "ERROR: No se encontro el actualizador del WAR buscado en la ubicacion $scriptFile" -ForegroundColor Red
		return $false
	}
	
	$arg = '"' + $updaterFile + '" "' + $warPath + '" "' + $WinRar + '"'
	$process = Start-Process -FilePath $scriptFile -ArgumentList $arg -NoNewWindow -Wait #-PassThru -Wait
	 
	if($process) {
		$process.WaitForExit()
        $ret = $process.ExitCode -eq 0
		verifyExitCode $ret "War Actualizado" "No se pudo actualizar los archivos en el War"
		return $ret
	}
	return $true
}

function verifyExitCode {
    param (
		[bool]$result,
        [string]$okMessage,
        [string]$errorMessage
    )
	# Comprobar si el comando termin bien
    if ($result) {
        Write-Host "EXITO ${okMessage}." -ForegroundColor Green
    } else {
		Write-Host "ERROR ${errorMessage}: $LASTEXITCODE" -ForegroundColor Red
    }    
}

function updateUpdater($destinyFolderBase)
{
	Write-Host "Actualizando updater" -ForegroundColor Yellow
	# Ruta al archivo XML
	$filePath = [System.IO.Path]::Combine($destinyFolderBase, "jetty\jetty\webapps\updater\updateComercio.xml")

	# Ruta al archivo XML
	$finalVersion = "1.41"

	# Obtener el nombre de la PC
	$pcName = $env:COMPUTERNAME

	if (-not (Test-Path -Path $filePath)) {
		Write-Host "ERROR No se encontro el archivo buscado en la ubicacion $filePath" -ForegroundColor Red
		return
	}

	# Leer el contenido del archivo XML
	[xml]$xmlContent = Get-Content -Path $filePath

	# Definir el namespace manager
	$namespaceManager = New-Object System.Xml.XmlNamespaceManager($xmlContent.NameTable)
	$namespaceManager.AddNamespace("ns", "http://ns.riaspace.com/air/framework/update/description/1.1")

	# Seleccionar el nodo <version> usando el namespace
	$versionNode = $xmlContent.SelectSingleNode("//ns:update/ns:exe/ns:version", $namespaceManager)

	# Verificar la versin actual y actualizarla si es necesario
	if ($versionNode -ne $null) {
		$versionNode.'#text' = $finalVersion
		Write-Host "EXITO Versin actualizada a $finalVersion" -ForegroundColor Green
	} else {
		Write-Host "ERROR No se encontro la version, no se realizaron cambios" -ForegroundColor Red
	}

	# Seleccionar el nodo <url> usando el namespace
	$urlNode = $xmlContent.SelectSingleNode("//ns:update/ns:exe/ns:url", $namespaceManager)

	# Reemplazar 'localhost' con el nombre de la PC en la URL
	if ($urlNode -ne $null -and $urlNode.'#text' -match "localhost") {
		$urlNode.'#text' = $urlNode.'#text' -replace "localhost", $pcName
		Write-Host "URL actualizada con el nombre de la PC: $pcName" -ForegroundColor Green
	} else {
		Write-Host "La URL no contiene 'localhost', no se realizaron cambios en la URL" -ForegroundColor Blue
	}

	# Guardar los cambios en el archivo XML
	$xmlContent.Save($filePath)
	verifyExitCode $? "Archivo guardado exitosamente en $filePath" "No se pudo guardar los cambios del archivo updater en $filePath"
}

function updateAir($destinyFolderBase)
{

	

    $exeFile = [System.IO.Path]::Combine($global:ScriptRoot, "CreditosComercio.exe") 

    if (-not (Test-Path -Path $exeFile)) {
		Write-Host "ERROR No se encontro el archivo EXE buscado en la ubicacion $exeFile" -ForegroundColor Red
		return
	}

    # Ruta al archivo exe
	$filePath = [System.IO.Path]::Combine($destinyFolderBase, "jetty\jetty\webapps\updater\CreditosComercio.exe")

    Write-Host "Copiando archivo CreditosComercio.exe" -ForegroundColor Yellow
    Copy-Item -Path "$exeFile" -Destination "$filePath" -Force
    verifyExitCode $? "Archivo CreditosComercio.exe copiado a $filePath" "No se pudo copiar CreditosComercio.exe en $filePath"
    Write-Host "Actualizando CreditosComercio.exe" -ForegroundColor Yellow
    & "$exeFile"
	verifyExitCode $? "CreditosComercio.exe ejecutado" "No se pudo ejecutar CreditosComercio.exe"
}

function buscarArchivoSiExiste
{
    param (
        [string]$folderBase,
        [string]$filename
    )

    $executable = [System.IO.Path]::Combine($folderBase, $filename)
    
    # Verificar si la carpeta existe en Program Files
    if (-not (Test-Path -Path $executable)) {
	    Write-Host "ERROR No se encontro el archivo $executable" -ForegroundColor Red
        exit
    }
    return $executable
}

function ejecutarArchivoSiExiste
 {
    param (
        [string]$folderBase,
        [string]$filename,
        [bool]$wait=$true
    )
    $executable = buscarArchivoSiExiste $folderBase $filename
    
    # Guardar la ruta actual
    $RutaOriginal = Get-Location
    
    # Obtener solo la ruta (directorio)
    $rutaSolo = [System.IO.Path]::GetDirectoryName($executable)
    # Obtener solo la ruta (directorio)
    #$executableSolo = [System.IO.Path]::GetFileName($executable)
    # Cambiar al nuevo directorio
    #Set-Location -Path $rutaSolo
    
    if ($wait) {
        $process = Start-Process "$executable" -NoNewWindow -Wait -WorkingDirectory $rutaSolo -OutVariable $output -RedirectStandardOutput "NUL"
    }
    else {
        $process = Start-Process "$executable" -NoNewWindow -WorkingDirectory $rutaSolo -OutVariable $output -RedirectStandardOutput "NUL"
    }
	if($process) {
		$process.WaitForExit()
		return ($process.ExitCode -eq 0)
	}
	return $true
    # Volver a la ruta original
    #Set-Location -Path $RutaOriginal
}

function findPathInProgramFiles($folderName)
{
    # Definir las rutas de Program Files y Program Files (x86)
    $programFilesPath = [System.IO.Path]::Combine($env:ProgramW6432, $folderName)
    $programFilesX86Path = [System.IO.Path]::Combine((${env:ProgramFiles(x86)}, ${env:ProgramFiles} -ne $null)[0], $folderName)

    # Verificar si la carpeta existe en Program Files
    if (Test-Path $programFilesPath) {
	    return $programFilesPath
    }
    # Verificar si la carpeta existe en Program Files (x86)
    elseif (Test-Path $programFilesX86Path) {
	    return $programFilesX86Path
    }
    else {
        return ""
    }
}

function findBaseInstalationPath() {
    
    # Definir el nombre de la carpeta que estamos buscando
    $folderName = "Ozono"
    $folderBase = findPathInProgramFiles($folderName)
    if ($folderBase -ne "") {
        $jettyFolderName = "jetty"
        if (existsSubpath $folderBase $jettyFolderName) {
            Write-Host "EXITO La carpeta '$folderName' se encuentra en: $folderBase" -ForegroundColor Green
            return $folderBase
        }
        else {
            if (existsSubpath ($env:SystemDrive + "\") $folderName) {
                $folderBase = [System.IO.Path]::Combine($env:SystemDrive + "\", $folderName)
                if (existsSubpath $folderBase $jettyFolderName) {
                    Write-Host "EXITO La carpeta '$folderName' se encuentra en: $folderBase" -ForegroundColor Green
                    return $folderBase
                }
            }
	    }
    }
    Write-Host "La carpeta '$folderName' no se encuentra en Program Files, Program Files (x86) o en C:\."
	return ""
}	

function existsSubpath() {
    param (
		[string]$folderBase,
        [string]$subfolderName
    )
    
    $testPath = [System.IO.Path]::Combine($folderBase, $subfolderName)
    return Test-Path $testPath
}

function updateMySql($folderBase)
{

	

    $batFile = [System.IO.Path]::Combine($global:ScriptRoot, "correr-script.bat") 
	#Write-Host "Ubicacion del script: $scriptFile"
    # Verificar si existe el script
    if (-not (Test-Path -Path $batFile)) {
	    Write-Host "ERROR No se encontro el bat $batFile" -ForegroundColor Red
        return $false
    }
	$scriptFile = [System.IO.Path]::Combine($global:ScriptRoot, "script.sql") 
	if (-not (Test-Path -Path $scriptFile)) {
	    Write-Host "ERROR No se encontro el script $scriptFile" -ForegroundColor Red
        return $false
    }
#	$query = Get-Content $scriptFile -Raw
#	$parameters = '-uroot -pcontrabajo -s --force'
#	< "' + $scriptFile + '"'
	$arg = '"' + $updaterFile + '" "' + $warPath + '" "' + $WinRar + '"'
	
	$arg = '"' + $folderBase + '" "' + $scriptFile + '"'
	
	$pinfo = New-Object System.Diagnostics.ProcessStartInfo
	$pinfo.FileName = $batFile
	$pinfo.UseShellExecute = $false
	$pinfo.Arguments = $arg
	$p = New-Object System.Diagnostics.Process
	$p.StartInfo = $pinfo
	$p.Start() | Out-Null
	$p.WaitForExit()

	if($p) {
		$ret = $p.ExitCode -eq 0
		verifyExitCode $ret "Script mysql ejecutado" "No se pudo ejecutar el script mysql"
		return $ret
	}
	return $true
	
    #ejecutarArchivoSiExiste $folderBase "correr-script.bat" $true
}

function getNroComercio($folderBase)
{

	$scriptFile = [System.IO.Path]::Combine($global:ScriptRoot, "obtener-comercio.bat") 
	#Write-Host "Ubicacion del script: $scriptFile"
    # Verificar si existe el script
    if (-not (Test-Path -Path $scriptFile)) {
	    Write-Host "ERROR No se encontro el script $scriptFile" -ForegroundColor Red
        return ""
    }
#	$query = Get-Content $scriptFile -Raw
#	$parameters = '-uroot -pcontrabajo -s --force'
#	< "' + $scriptFile + '"'
	$arg = '"' + $folderBase + '"'
	#$process = Start-Process -FilePath $scriptFile -ArgumentList $arg -NoNewWindow -PassThru -Wait -RedirectStandardOutput $result
	
	$pinfo = New-Object System.Diagnostics.ProcessStartInfo
	$pinfo.FileName = $scriptFile
	$pinfo.RedirectStandardError = $true
	$pinfo.RedirectStandardOutput = $true
	$pinfo.UseShellExecute = $false
	$pinfo.Arguments = $arg
	$p = New-Object System.Diagnostics.Process
	$p.StartInfo = $pinfo
	$p.Start() | Out-Null
	$p.WaitForExit()

	if($p) {
		$stdout = $p.StandardOutput.ReadToEnd() -replace "`n$",""
		$stderr = $p.StandardError.ReadToEnd()
		$ret = $p.ExitCode -eq 0
		verifyExitCode $ret "Comercio obtenido: $stdout" "No se pudo obtener el comercio: $stderr"
		return $stdout
	}
	return ""
}

function enviarEmail {
	param ( [string]$transcriptFile,
			[string]$comercio
			)
	
	# Configuracin de los parmetros
	$smtpServer = "mail.ozonoinformatica.com.ar" 
	$smtpFrom = "reportes@ozonoinformatica.com.ar"
	$smtpTo = "fernando@ozonoinformatica.com.ar"
	
	if ($comercio -ne "") {
		$messageSubject = "Act. Santo Tome - " + $comercio.Substring(0, 5)
	}
	else {
		$messageSubject = "Act. Santo Tome - Comercio desconocido"
	}
	$messageBody = Get-Content -Path $transcriptFile | Out-String
    $securePassword = ConvertTo-SecureString "Rpt.2024!" -AsPlainText -Force
    $credentials = New-Object System.Management.Automation.PSCredential("reportes@ozonoinformatica.com.ar", $securePassword)
    $smtpPort = 26
    $mail = New-Object system.net.mail.mailmessage
    $smtp = New-Object system.net.mail.smtpclient($smtpServer, $smtpPort)
    $mail.from = $smtpFrom
    $mail.To.Add($smtpTo)
    $mail.Subject = $messageSubject
    $mail.Body = $messageBody
    $smtp.EnableSsl = $false
    $smtp.Credentials = $credentials
    try {
        $smtp.Send($mail)
        Write-Host "EXITO Correo enviado con xito" -ForegroundColor Green
    } catch {
        Write-Host "ERROR al enviar el correo: $_" -ForegroundColor Red
    }
	

}
$global:ScriptRoot = Split-Path -Parent $MyInvocation.MyCommand.Definition
Write-Host "Raiz $global:ScriptRoot" -ForegroundColor Blue

# Iniciar la transcripcin

$scriptFile = [System.IO.Path]::Combine($global:ScriptRoot, "transcript.txt") 
try{
	Start-Transcript -Path $scriptFile | Out-Null
}
catch {
	Write-Host "Transcripcion no disponible" -ForegroundColor Blue
}

# Definir el nombre de la carpeta que estamos buscando
$folderBase = findBaseInstalationPath

if ($folderBase -ne "") {
    $env:MYSQL_PWD = "contrabajo"

    $comercio = getNroComercio($folderBase)
    if ($comercio -ne "") {
        $result = ejecutarArchivoSiExiste $folderBase "jetty\jetty\stop.bat"
        verifyExitCode $result "Jetty Detenido" "No se pudo detener el Jetty"
        if (updateMySql($folderBase)) {
            if (updateWar($folderBase)) {
                updateUpdater($folderBase)
                updateAir($folderBase)
            }
        }
        $result = ejecutarArchivoSiExiste $folderBase "jetty\jetty\start.bat" $false
        verifyExitCode $result "Jetty Iniciado" "No se pudo iniciar el Jetty"
    }
}
# Detener la transcripcin
try{
	Stop-Transcript | Out-Null
}
catch {
}
enviarEmail $scriptFile $comercio

