use creditoscomercio;

alter table recibo add constraint unique (codcentral);
alter table direccion add constraint unique (codcentral);
alter table liquidacion add constraint unique (codcentral);
alter table telefono add constraint unique (codcentral);
alter table recibo add constraint unique (codcentral);
alter table pago add constraint unique (codcentral);
alter table notacredito add constraint unique (codcentral);
alter table mensaje add constraint unique (codcentral);
  
alter table refinanciacion modify column `codCreditoRefinanciado` int(11) NULL;
alter table refinanciacion add `flgActivo` bit(1) NOT NULL default 1;

alter table credito add `strCbu` varchar(50) NULL;

alter table remotecredito add `strCbu` varchar(50) NULL;

alter table tipocliente add valCupoMaximoVencida decimal(10,0) not null default 0;

update TipoCliente set valCupoMaximoVencida = valCupoMaximo;

DROP PROCEDURE recalcular_clientexcomercio;
DELIMITER //
CREATE PROCEDURE recalcular_clientexcomercio(pcliente int, pcomercio int)
BEGIN
	declare vvalCapitalAdelantada decimal(10,2);
	declare vvalCapitalVencida decimal(10,2);
	declare vvalCapitalPagado decimal(10,2);
	declare vvalCapitalRefinanciado decimal(10,2);
	declare vvalCapitalRefinanciadoPagado decimal(10,2);
	declare vvalCuotasPagadas decimal(10,2);
	declare vvalSaldoCapital decimal(10,2);
	declare vvalSaldoCapitalRefinanciaciones decimal(10,2);
	declare vvalCapitalCuotasPagadas decimal(10,2);
    declare vvalCapitalCuotasPagadasAdelantadas decimal(10,2);
	declare vcapital decimal(10,2);
	#por cada clientexcomercio
    
    #tomamos los creditos refinanciados y activos 
	select ifnull(sum(valcapital - valcapitalajustado - valcapitalpagado), 0) 
		into vvalSaldoCapitalRefinanciaciones
        from credito 
        where codcliente = pcliente and codcomercio = pcomercio 
			#and codestado != 4 
            and codEstadoDeProceso != 4 
            and codEstadoDeProceso != 7
            and codestado = 1
            and flgRefinanciado = 1;
	
	#tomamos los creditos refinanciados
	select ifnull(sum(valcapital - valcapitalajustado), 0), ifnull(sum(valcapitalpagado), 0)
		into vvalCapitalRefinanciado, vvalCapitalRefinanciadoPagado
        from credito 
        where codcliente = pcliente and codcomercio = pcomercio 
			and codestado != 4 
            and codEstadoDeProceso != 4 
            and codEstadoDeProceso != 7
            and flgRefinanciado = 1;
            
	#tomamos los creditos no refis activos 
	select ifnull(sum(valcapital - valcapitalajustado - valcapitalpagado), 0) 
		into vvalSaldoCapital
        from credito 
        where codcliente = pcliente and codcomercio = pcomercio 
			#and codestado != 4 
            and codEstadoDeProceso != 4 
            and codEstadoDeProceso != 7
            and codestado = 1
            and flgRefinanciado = 0;  
            
	#tomamos los creditos no refis
	select ifnull(sum(valcapitalpagado), 0)
		into vvalCapitalCuotasPagadas
        from credito 
        where codcliente = pcliente and codcomercio = pcomercio 
			and codestado != 4 
            and codEstadoDeProceso != 4 
            and codEstadoDeProceso != 7
            and flgRefinanciado = 0;  
	
    #tomamos los creditos no refis y cuota adelantada
	select ifnull(sum(valcapital), 0), ifnull(sum(round(valCapital / cntcuotas, 0)), 0)
		into vvalCapitalAdelantada, vvalCapitalCuotasPagadasAdelantadas
        from credito 
        where codcliente = pcliente and codcomercio = pcomercio 
			and codestado != 4 
            and codEstadoDeProceso != 4 
            and codEstadoDeProceso != 7
            and flgRefinanciado = 0
            and flgCuotaAdelantada = 1;  
	#tomamos los creditos no refis y cuota vencida
	select ifnull(sum(valcapital), 0)
		into vvalCapitalVencida
        from credito 
        where codcliente = pcliente and codcomercio = pcomercio 
			and codestado != 4 
            and codEstadoDeProceso != 4 
            and codEstadoDeProceso != 7
            and flgRefinanciado = 0
            and flgCuotaAdelantada = 0; 
		
    
    #tomamos los creditos no refis
	select ifnull(sum(valcapitalPagado), 0), ifnull(sum(valCapitalPagado + valinteresPagado), 0)
		into vvalCapitalPagado, vvalCuotasPagadas
        from credito 
        where codcliente = pcliente and codcomercio = pcomercio 
			and codestado != 4 
            and codEstadoDeProceso != 4 
            and codEstadoDeProceso != 7
            and flgRefinanciado = 0; 
		
	update clientexcomercio set 
		valCapitalAdelantada = ifnull(vvalCapitalAdelantada, 0),
		valCapitalVencida = ifnull(vvalCapitalVencida, 0),
		valCapitalPagado = ifnull(vvalCapitalPagado, 0),
		valCapitalRefinanciado = ifnull(vvalCapitalRefinanciado , 0),
		valCapitalRefinanciadoPagado = ifnull(vvalCapitalRefinanciadoPagado, 0) ,
		valCuotasPagadas = ifnull(vvalCuotasPagadas, 0),
		valSaldoCapital = ifnull(vvalSaldoCapital, 0),
		valSaldoCapitalRefinanciaciones = ifnull(vvalSaldoCapitalRefinanciaciones, 0),
		valCapitalCuotasPagadas = ifnull(vvalCapitalCuotasPagadas - vvalCapitalCuotasPagadasAdelantadas, 0)
    where  codcliente = pcliente and codcomercio = pcomercio;
        
END; //